VERSION 5.00
Begin VB.Form frmVirMask 
   Caption         =   "Form1"
   ClientHeight    =   3375
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   8010
   LinkTopic       =   "Form1"
   ScaleHeight     =   225
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   534
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox picDisplay 
      Height          =   1980
      Left            =   4440
      ScaleHeight     =   128
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   128
      TabIndex        =   2
      Top             =   960
      Width           =   1980
   End
   Begin VB.PictureBox picSelection 
      Height          =   1980
      Left            =   1560
      ScaleHeight     =   128
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   128
      TabIndex        =   1
      Top             =   960
      Width           =   1980
   End
   Begin VB.PictureBox picTiles 
      Height          =   570
      Left            =   0
      ScaleHeight     =   34
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   529
      TabIndex        =   0
      Top             =   0
      Width           =   7995
   End
End
Attribute VB_Name = "frmVirMask"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private VirMask(2047) As Byte
Private bmPasteInfo As BITMAPINFO
Private block(4, 4) As Byte

Private Sub Form_Load()
    ' Read in the data
    Open "virmask.raw" For Binary As #1
    Get #1, 1, VirMask
    Close #1

    ' Setup bitmap header structure needed for pasting
    With bmPasteInfo.bmiHeader
        .biSize = Len(bmPasteInfo.bmiHeader)
        .biBitCount = 1
        .biWidth = 32
        .biHeight = -32 * 16
        .biPlanes = 1
        .biCompression = BI_RGB
    End With
    With bmPasteInfo.bmiColors(1)
        .rgbRed = 255
        .rgbGreen = 255
        .rgbBlue = 255
    End With
    
    
    
    Dim i As Long
    Dim j As Long
    
    ' Clear the last tile
    For i = 2048 - 32 * 32 / 8 To 2047
        VirMask(i) = 0
    Next i
End Sub

Private Sub ChangeSelection(X As Long, Y As Long)
    Dim tileX As Long
    Dim tileY As Long

    tileX = X \ 32
    tileY = Y \ 32
    If tileX >= 0 And tileX < 4 And tileY >= 0 And tileY < 4 Then
        block(tileX, tileY) = block(tileX, tileY) Xor 1
        
        picSelection_Paint
        picDisplay_Paint
    End If
End Sub

Private Sub picDisplay_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And vbLeftButton = vbLeftButton Then
        ChangeSelection (X), (Y)
    End If
End Sub

Private Sub picDisplay_Paint()
    Dim lngRet As Long
    Dim i As Long
    Dim j As Long
    Dim tileIndex As Long
    
    For j = 0 To 3
        For i = 0 To 3
            tileIndex = block(i, j) Or block(i + 1, j) * 2 Or block(i, j + 1) * 4 Or block(i + 1, j + 1) * 8
            lngRet = SetDIBitsToDevice(picDisplay.hDC, i * 32, j * 32, 32, 32, 0, tileIndex * 32, 0, 32 * 16, VirMask(0), bmPasteInfo, 0)
        Next i
    Next j
End Sub

Private Sub picSelection_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And vbLeftButton = vbLeftButton Then
        ChangeSelection (X), (Y)
    End If
End Sub

Private Sub picSelection_Paint()
    Dim i As Long
    Dim j As Long

    For j = 0 To 3
        For i = 0 To 3
            If block(i, j) = 1 Then
                picSelection.Line (i * 32, j * 32)-(i * 32 + 32, j * 32 + 32), RGB(255, 0, 0), BF
            Else
                picSelection.Line (i * 32, j * 32)-(i * 32 + 32, j * 32 + 32), RGB(0, 0, 0), BF
            End If
        Next i
    Next j
End Sub

Private Sub picTiles_Paint()
    Dim lngRet As Long
    Dim i As Long
    Dim j As Long
    
    For i = 0 To 15
        picTiles.Line (i * 33, 0)-(i * 33 + 33, 33), RGB(255, 0, 0), B
        lngRet = SetDIBitsToDevice(picTiles.hDC, i * 33 + 1, 1, 32, 32, 0, i * 32, 0, 32 * 16, VirMask(0), bmPasteInfo, 0)
    Next i
End Sub
